package com.skilldistillery.regex.solutions;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexProcessor2 {

  public static void main(String[] args) {
    RegexProcessor2 processor = new RegexProcessor2();
    processor.launch("regex_quotes.txt");
  }

  private void launch(String fileName) {
    try {
      BufferedReader br = new BufferedReader(new FileReader(fileName));
      String line;
      while ((line = br.readLine()) != null) {
//        this.printIfStartsWithHyphen(line);
        this.printCapitalizedWords(line);
      }
      br.close();
    }
    catch (FileNotFoundException e) {
      System.err.println("File not found: " + fileName);
      return;
    }
    catch (IOException e) {
      e.printStackTrace();
      return;
    }
  }
  
  private void printCapitalizedWords(String text) {
    Pattern p = Pattern.compile("\\b[A-Z]\\w+");
    Matcher m = p.matcher(text);
    while (m.find()) {
      String word = m.group(); // or m.group(0)
      System.out.println(word);
    }
  }

  private void printIfStartsWithHyphen(String text) {
    if (text.matches("^-.*")) {
      System.out.println(text);
    }
  }

}
